// CLS_PageSettingPicture.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_PageSettingPicture.h"
#include "Include\CommonFun.h"
#include "Include/CLS_NVDSDK_Interface.h"

// CLS_PageSettingPicture dialog
#define DEFAULT_SCREEN_SIZE	10000
#define DEFAULT_PIC_SIZE	1000
#define PIC_COLOR		RGB(2, 153, 0)
#define BACK_COLOR		RGB(0, 0, 0)
#define LINE_COLOR		RGB(255, 0, 0)
#define WINDOW_COLOR	RGB(255, 0, 0)
IMPLEMENT_DYNAMIC(CLS_PageSettingPicture, CDialog)

#ifdef SDK_X64
#define GCL_HCURSOR GCLP_HCURSOR
#endif

CLS_PageSettingPicture::CLS_PageSettingPicture(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_PageSettingPicture::IDD, pParent)
{
	m_lLogonID = -1;
	m_iChannelNo = 0;
	m_iPicNum = 0;
	m_iRectHeight = 0;
	m_iRectWidth = 0;
	m_iRow = 3;
	m_iCol = 3;
	m_iCurPicNo = 0;
	m_bMoveRect = FALSE;
	m_bMoveLine = FALSE;

	memset(m_stScreenPara, 0, sizeof(ScreenPara)*DEC_MAX_SPLIT_SCREEN_NUM);	
	memset(&m_tPicLevel, 0, sizeof(DecPicLevelRelation));
}

CLS_PageSettingPicture::~CLS_PageSettingPicture()
{
}

void CLS_PageSettingPicture::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_NO, m_cboScreenNo);
	DDX_Control(pDX, IDC_STATIC_PICTURE_CUT, m_staticVideoRect);
	DDX_Control(pDX, IDC_EDIT_PICNUM, m_editPicNum);
	DDX_Control(pDX, IDC_EDT_X, m_edtX);
	DDX_Control(pDX, IDC_EDT_Y, m_edtY);
	DDX_Control(pDX, IDC_EDT_W, m_edtW);
	DDX_Control(pDX, IDC_EDT_H, m_edtH);
	DDX_Control(pDX, IDC_COMBO_SCREEN_NUM, m_cboPosNum);
	DDX_Control(pDX, IDC_COMBO_SCREEN_DISPLAY, m_cboScreenDisplay);
	DDX_Control(pDX, IDC_CBO_POS_NO, m_cboPosNo);
	DDX_Control(pDX, IDC_CBO_ENABLE, m_cboEnable);
	DDX_Control(pDX, IDC_BTN_SET, m_btnSetWindow);
	DDX_Control(pDX, IDC_EDIT_PIC_LEVEL_RELATION, m_edtPicLevel);
}


BEGIN_MESSAGE_MAP(CLS_PageSettingPicture, CDialog)
	ON_BN_CLICKED(IDC_BTN_PIC_SET, &CLS_PageSettingPicture::OnBnClickedBtnPicSet)
	ON_WM_SHOWWINDOW()
	ON_WM_PAINT()
	ON_CBN_SELCHANGE(IDC_COMBO_NO, &CLS_PageSettingPicture::OnCbnSelchangeComboNo)
	ON_EN_KILLFOCUS(IDC_EDT_X, &CLS_PageSettingPicture::OnEnKillfocusEdtX)
	ON_EN_KILLFOCUS(IDC_EDT_Y, &CLS_PageSettingPicture::OnEnKillfocusEdtY)
	ON_EN_KILLFOCUS(IDC_EDT_W, &CLS_PageSettingPicture::OnEnKillfocusEdtW)
	ON_EN_KILLFOCUS(IDC_EDT_H, &CLS_PageSettingPicture::OnEnKillfocusEdtH)
	ON_BN_CLICKED(IDC_BUTTON_SCREEN_DISPLAY, &CLS_PageSettingPicture::OnBnClickedButtonScreenDisplay)
	ON_CBN_SELCHANGE(IDC_COMBO_SCREEN_NUM, &CLS_PageSettingPicture::OnCbnSelchangeComboScreenNum)
	ON_BN_CLICKED(IDC_BUTTON_SIGNAL_SCREEN_SET, &CLS_PageSettingPicture::OnBnClickedButtonSignalScreenSet)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_PICLEVEL_RELATION, &CLS_PageSettingPicture::OnBnClickedButtonSavePiclevelRelation)
END_MESSAGE_MAP()


// CLS_PageSettingPicture message handlers
int CLS_PageSettingPicture::Initialize(TDECPARAM* _pdecParam)
{
	if (_pdecParam == NULL)
	{
		return -1;
	}

	m_iChannelNo = _pdecParam->m_iChannel;
	return 0;
}

void CLS_PageSettingPicture::OnBnClickedBtnPicSet()
{
	int iScreenNo = GetComboData(&m_cboScreenNo);

	SplitScreen stSplitScreen = {0};
	stSplitScreen.iBufSize = sizeof(SplitScreen);
	stSplitScreen.iVVOChannelNo = iScreenNo;
	stSplitScreen.iPicNum = m_iPicNum;

	for (int i=0; i<m_iPicNum; i++)
	{
		stSplitScreen.tSplitScreenPara[i].iBufSize = sizeof(ScreenPara);
		stSplitScreen.tSplitScreenPara[i].iX = m_stScreenPara[i].iX;
		stSplitScreen.tSplitScreenPara[i].iY = m_stScreenPara[i].iY;
		stSplitScreen.tSplitScreenPara[i].iHeight = m_stScreenPara[i].iHeight;
		stSplitScreen.tSplitScreenPara[i].iWidth = m_stScreenPara[i].iWidth;
	}
		
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iScreenNo, 0, CMD_DEC_CFG_SPLIT_SCREEN, &stSplitScreen, sizeof(SplitScreen));
	if(iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::OnBnClickedBtnPicSet] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d)",
			iRet, GetLastError(), CMD_DEC_CFG_SPLIT_SCREEN);
	}
}

void CLS_PageSettingPicture::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	if (bShow)
	{
		m_cboScreenNo.SetCurSel(0);
		GetScreenInfo();
		GetScreenDisplayInfo();
		GetScreenAreaInfo();
		UpdatePicLevelRelation();
	}	
}

BOOL CLS_PageSettingPicture::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetDlgItemText(IDC_BTN_PIC_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_STATIC_PAGE_SET, GetText(IDS_SETTING_PAGE_SET));
	SetDlgItemText(IDC_STATIC_NO, GetText(IDS_CFG_LOG_DVR_CHANNEL));
	SetDlgItemText(IDC_STATIC_PIC_NUM, GetText(IDS_STRING_PAGE_NUM));
	SetDlgItemText(IDC_STATIC_CUSTOM_CUT, GetText(IDS_STRING_CUSTOM_PAGE_CUT));

	int iRet = CreateChannelCombo(m_lLogonID, &m_cboScreenNo);

	BaseOffset tGetStartAddress;
	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
	}
	
	CString cstrScreenNo;
	for(int i = 0; i < DEC_MAX_FLOAT_WINDOW_NUM; i++)
	{
		cstrScreenNo.Format("%d", i + tGetStartAddress.iFloatWindow);
		m_cboPosNo.AddString(cstrScreenNo);
	}
	m_cboPosNo.SetCurSel(0);

	m_cboEnable.AddString("0");
	m_cboEnable.AddString("1");
	m_cboEnable.SetCurSel(0);

	RECT rect = {0};
	GetDlgItem(IDC_STATIC_PICTURE_CUT)->GetWindowRect(&rect);
	m_iRectWidth = rect.right - rect.left;
	m_iRectHeight = rect.bottom - rect.top;

	m_edtX.SetLimitText(5);
	m_edtY.SetLimitText(5);
	m_edtW.SetLimitText(5);
	m_edtH.SetLimitText(5);
	GetScreenInfo();
	CreatePosCombo(m_lLogonID,m_iChannelNo,0,&m_cboPosNum,0);
	m_cboPosNum.SetCurSel(0);
	
	m_cboScreenDisplay.AddString(GetText(IDS_SETTING_SCREEN_HIDE));
	m_cboScreenDisplay.AddString(GetText(IDS_SETTING_SCREEN_SHOW));
	m_cboScreenDisplay.SetCurSel(1);

	SetDlgItemText(IDC_BUTTON_SCREEN_DISPLAY, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_STATIC_SCREEN_NUM, GetText(IDS_SETTING_SCREEN_NUMBER));
	SetDlgItemText(IDC_STATIC_SCREEN_DISPLAY, GetText(IDS_SETTING_SCREEN_HIDE_SHOW));

	m_cboPosNo.SetCurSel(0);
	m_cboEnable.SetCurSel(0);
	m_cboPosNum.SetCurSel(0);
	m_cboScreenDisplay.SetCurSel(0);

	m_edtPicLevel.LimitText(LEN_1024);

	return TRUE;
}

void CLS_PageSettingPicture::OnCbnSelchangeComboNo()
{
	GetScreenInfo();
	UpdatePicLevelRelation();
}

void CLS_PageSettingPicture::GetScreenInfo()
{
	int iScreenNo = GetComboData(&m_cboScreenNo);

	//ȡƴش
	SplitScreen stSplitScreen = {0};
	stSplitScreen.iBufSize = sizeof(SplitScreen);
	stSplitScreen.iVVOChannelNo = iScreenNo;

	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SPLIT_SCREEN, &stSplitScreen, sizeof(SplitScreen));
	if(iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::OnCbnSelchangeComboNo] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_SPLIT_SCREEN);
	}
	else
	{
		m_iPicNum = stSplitScreen.iPicNum;

		ChannelPicNum tPicNum = {0};
		tPicNum.iSize = sizeof(ChannelPicNum);

		iRet = DEC_ClientGetDevConfig(m_lLogonID, iScreenNo, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
		if (ERR_SUCCESS == iRet)
		{
			m_iPicNum = tPicNum.iPicNum;
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR, "[CLS_PageSettingPicture::OnCbnSelchangeComboNo] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
				iRet, CMD_DEC_CFG_PICNUM);
		}

		if (m_iPicNum < 0 || m_iPicNum > DEC_MAX_PICTURE_NUM)
		{
			m_iPicNum = 0;
		}

		SetDlgItemInt(IDC_EDIT_PICNUM, m_iPicNum);
		memset(m_stScreenPara, 0, sizeof(ScreenPara)*DEC_MAX_SPLIT_SCREEN_NUM);
		memcpy(m_stScreenPara, stSplitScreen.tSplitScreenPara, sizeof(ScreenPara)*DEC_MAX_PICTURE_NUM);
		m_cboPosNum.ResetContent();
		CreatePosCombo(m_lLogonID,iScreenNo,0,&m_cboPosNum,0);
		for (int i=0; i< m_iPicNum; i++)
		{
			/*char cTmp[16] = {0};
			sprintf(cTmp, "%d", i);
			m_cboPosNum.AddString(_T(cTmp));*/
			if (m_stScreenPara[i].iWidth == 0 || m_stScreenPara[i].iHeight == 0)
			{
				m_stScreenPara[i].iX = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
				m_stScreenPara[i].iY = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
				m_stScreenPara[i].iWidth = DEFAULT_PIC_SIZE;
				m_stScreenPara[i].iHeight = DEFAULT_PIC_SIZE;
			}
		}
		m_cboPosNum.SetCurSel(0);
		DrawMutiPicArea();
	}
}

void CLS_PageSettingPicture::DrawMutiPicArea()
{
	CWnd *pWnd = GetDlgItem(IDC_STATIC_PICTURE_CUT);
	if (pWnd == NULL)
	{
		return;
	}
	CDC *pCDC = pWnd->GetDC();
	if (pCDC == NULL)
	{
		return;
	}

	CBitmap bitmap;
	if (0 == bitmap.CreateCompatibleBitmap(pCDC, m_iRectWidth, m_iRectHeight))
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]CreateCompatibleBitmap Failed!");
	}

	CDC memDC;
	if (0 == memDC.CreateCompatibleDC(NULL))
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]CreateCompatibleDC Failed!");
	}

	CBitmap* pOldBitMap = memDC.SelectObject(&bitmap);
	memDC.FillSolidRect(0, 0, m_iRectWidth, m_iRectHeight, BACK_COLOR); //䱳ɫ
	memDC.SetBkMode(TRANSPARENT);
	memDC.SetMapMode(MM_ANISOTROPIC);
	memDC.SetViewportExt(m_iRectWidth, m_iRectHeight);
	memDC.SetWindowExt(DEFAULT_SCREEN_SIZE, DEFAULT_SCREEN_SIZE);

	int iX1 = 0;
	int iX2 = 0;
	int iY1 = 0;
	int iY2 = 0;
	CString strText;

	//ƻ
	CBrush* pOldBrush = NULL;
	CBrush brushPic(PIC_COLOR);

	pOldBrush = memDC.SelectObject(&brushPic);
	for (int i = m_iPicNum; i > 0; i--)
	{
		iX1 = m_stScreenPara[i-1].iX;
		iX2 = iX1 + m_stScreenPara[i-1].iWidth;
		iY1 = m_stScreenPara[i-1].iY;
		iY2 = iY1 + m_stScreenPara[i-1].iHeight;
		memDC.Rectangle(iX1, iY1, iX2, iY2);
		strText.Format("%d", i);
		memDC.TextOut(iX1 + 100, iY1 + 100, strText);
	}

	

	memDC.SelectObject(pOldBrush);

	//ͨ
	CPen penRed(PS_DASH, 0, LINE_COLOR);
	CPen* pOldPen = memDC.SelectObject(&penRed);
	for (int i = 1; i < m_iRow; i++)
	{
		memDC.MoveTo(0, (DEFAULT_SCREEN_SIZE*i)/m_iRow);
		memDC.LineTo(DEFAULT_SCREEN_SIZE, (DEFAULT_SCREEN_SIZE*i)/m_iRow);
	}

	for (int i = 1; i < m_iCol; i++)
	{
		memDC.MoveTo((DEFAULT_SCREEN_SIZE*i)/m_iCol, 0);
		memDC.LineTo((DEFAULT_SCREEN_SIZE*i)/m_iCol, DEFAULT_SCREEN_SIZE);
	}

	memDC.SelectObject(pOldPen);

	pCDC->StretchBlt(0, 0, m_iRectWidth, m_iRectHeight, &memDC, 0, 0, DEFAULT_SCREEN_SIZE, DEFAULT_SCREEN_SIZE, SRCCOPY);
	
	memDC.SelectObject(pOldBitMap);
	if (0 == bitmap.DeleteObject())
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]bitmap.DeleteObject() Failed!");
	}

	if (0 == memDC.DeleteDC())
	{
		AddLog(LOG_LEVEL_DEBUG, "[CLS_PageSettingPicture::DrawMutiPicArea]memDC.DeleteDC() Failed!");
	}

	pWnd->ReleaseDC(pCDC);
}

void CLS_PageSettingPicture::OnPaint()
{
	CPaintDC dc(this); // ڻƵ豸
	DrawMutiPicArea();
	CDialog::OnPaint();	
}

LRESULT CLS_PageSettingPicture::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (GetDlgItem(IDC_STATIC_PICTURE_CUT))
	{
		RECT rc = {0};
		POINT pt = {0};
		GetCursorPos(&pt);

		GetDlgItem(IDC_STATIC_PICTURE_CUT)->GetWindowRect(&rc);

		if (::PtInRect(&rc, pt))
		{
			switch(message)
			{
			case WM_LBUTTONDOWN:
				{
					GetDlgItem(IDC_STATIC_PICTURE_CUT)->ScreenToClient(&pt);
					pt.x = pt.x * 10000 / m_iRectWidth;
					pt.y = pt.y * 10000 / m_iRectHeight;


					for (int i=0; i < m_iPicNum; i++)
					{
						rc.left = m_stScreenPara[i].iX;
						rc.right = rc.left + m_stScreenPara[i].iWidth;
						rc.top = m_stScreenPara[i].iY;
						rc.bottom = rc.top + m_stScreenPara[i].iHeight;


						if (::PtInRect(&rc, pt))
						{
							m_iCurPicNo = i;
							m_cboPosNum.SetCurSel(i);
							GetScreenDisplayInfo();
							GetScreenAreaInfo();
							m_bMoveRect = TRUE;
							m_bMoveLine = FALSE;
							m_ptPrePoint = pt;
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZEALL));
							SetDlgItemInt(IDC_EDT_X, m_stScreenPara[m_iCurPicNo].iX);
							SetDlgItemInt(IDC_EDT_Y, m_stScreenPara[m_iCurPicNo].iY);
							SetDlgItemInt(IDC_EDT_W, m_stScreenPara[m_iCurPicNo].iWidth);
							SetDlgItemInt(IDC_EDT_H, m_stScreenPara[m_iCurPicNo].iHeight);

							break;
						}

						if (rc.right - 200 < pt.x 
							&& rc.right + 200 > pt.x 
							&& rc.bottom - 200 < pt.y
							&& rc.bottom + 200 >pt.y)
						{
							m_iCurPicNo = i;
							m_bMoveLine = TRUE;
							m_bMoveRect = FALSE;
							m_ptPrePoint = pt;
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZENWSE));
							break;
						}
					}
				}
				break;
			case WM_LBUTTONUP:
				{		
					m_bMoveRect = FALSE;
					m_bMoveLine = FALSE;
					SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));							
				}
				break;
			case WM_MOUSEMOVE:
				{
					GetDlgItem(IDC_STATIC_PICTURE_CUT)->ScreenToClient(&pt);
					pt.x = pt.x * DEFAULT_SCREEN_SIZE / m_iRectWidth;
					pt.y = pt.y * DEFAULT_SCREEN_SIZE / m_iRectHeight;
					if (m_bMoveRect || m_bMoveLine)
					{
						int iX = pt.x - m_ptPrePoint.x;
						int iY = pt.y - m_ptPrePoint.y;
						m_ptPrePoint = pt;				

						if (m_bMoveRect)
						{
							if (m_stScreenPara[m_iCurPicNo].iX + iX < 0 
								|| m_stScreenPara[m_iCurPicNo].iX  + iX + m_stScreenPara[m_iCurPicNo].iWidth > DEFAULT_SCREEN_SIZE
								|| m_stScreenPara[m_iCurPicNo].iY + iY < 0 
								|| m_stScreenPara[m_iCurPicNo].iY + iY + m_stScreenPara[m_iCurPicNo].iHeight > DEFAULT_SCREEN_SIZE)
							{
								break;
							}

							m_stScreenPara[m_iCurPicNo].iX += iX;
							m_stScreenPara[m_iCurPicNo].iY += iY;
						}

						if (m_bMoveLine)
						{
							if (m_stScreenPara[m_iCurPicNo].iX  + iX + m_stScreenPara[m_iCurPicNo].iWidth > DEFAULT_SCREEN_SIZE 
								|| m_stScreenPara[m_iCurPicNo].iY + iY + m_stScreenPara[m_iCurPicNo].iHeight > DEFAULT_SCREEN_SIZE)
							{
								break;
							}

							m_stScreenPara[m_iCurPicNo].iHeight += iY;
							m_stScreenPara[m_iCurPicNo].iWidth += iX;
						}

						if (m_stScreenPara[m_iCurPicNo].iHeight < DEFAULT_PIC_SIZE)
						{
							m_stScreenPara[m_iCurPicNo].iHeight = DEFAULT_PIC_SIZE;
						}

						if (m_stScreenPara[m_iCurPicNo].iWidth < DEFAULT_PIC_SIZE)
						{
							m_stScreenPara[m_iCurPicNo].iWidth = DEFAULT_PIC_SIZE;
						}

						DrawMutiPicArea();

						SetDlgItemInt(IDC_EDT_X, m_stScreenPara[m_iCurPicNo].iX);
						SetDlgItemInt(IDC_EDT_Y, m_stScreenPara[m_iCurPicNo].iY);
						SetDlgItemInt(IDC_EDT_W, m_stScreenPara[m_iCurPicNo].iWidth);
						SetDlgItemInt(IDC_EDT_H, m_stScreenPara[m_iCurPicNo].iHeight);
					}
					else
					{
						bool bExist = false;

						for (int i=0; i < m_iPicNum; i++)
						{
							rc.left = m_stScreenPara[i].iX;
							rc.right = rc.left + m_stScreenPara[i].iWidth;
							rc.top = m_stScreenPara[i].iY;
							rc.bottom = rc.top + m_stScreenPara[i].iHeight;


							if (::PtInRect(&rc, pt))
							{
								SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZEALL));
								bExist = true;
								break;
							}

							if (rc.right - 200 < pt.x 
								&& rc.right + 200 > pt.x 
								&& rc.bottom - 200 < pt.y
								&& rc.bottom + 200 >pt.y)
							{
								SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_SIZENWSE));
								bExist = true;
								break;
							}
						}

						if (!bExist)
						{
							SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));
						}
					}
				}
				break;
			default:
				break;
			}
		}	
		else
		{
			m_bMoveRect = FALSE;
			m_bMoveLine = FALSE;
			SetClassLong(this->GetSafeHwnd(), GCL_HCURSOR, (LONG)LoadCursor(NULL, IDC_ARROW));							
		}
	}

	return CDialog::WindowProc(message, wParam, lParam);
}

void CLS_PageSettingPicture::OnEnKillfocusEdtX()
{
	// TODO: Add your control notification handler code here
	m_stScreenPara[m_iCurPicNo].iX = GetDlgItemInt(IDC_EDT_X);
	if (m_stScreenPara[m_iCurPicNo].iX > DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iX = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
	}

	if (m_stScreenPara[m_iCurPicNo].iX + m_stScreenPara[m_iCurPicNo].iWidth > DEFAULT_SCREEN_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iX = DEFAULT_SCREEN_SIZE - m_stScreenPara[m_iCurPicNo].iWidth;
	}

	SetDlgItemInt(IDC_EDT_X, m_stScreenPara[m_iCurPicNo].iX);

	DrawMutiPicArea();
}

void CLS_PageSettingPicture::OnEnKillfocusEdtY()
{
	// TODO: Add your control notification handler code here
	m_stScreenPara[m_iCurPicNo].iY = GetDlgItemInt(IDC_EDT_Y);
	if (m_stScreenPara[m_iCurPicNo].iY > DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iY = DEFAULT_SCREEN_SIZE - DEFAULT_PIC_SIZE;
	}

	if (m_stScreenPara[m_iCurPicNo].iY + m_stScreenPara[m_iCurPicNo].iHeight > DEFAULT_SCREEN_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iY = DEFAULT_SCREEN_SIZE - m_stScreenPara[m_iCurPicNo].iHeight;
	}

	SetDlgItemInt(IDC_EDT_Y, m_stScreenPara[m_iCurPicNo].iY);

	DrawMutiPicArea();
}

void CLS_PageSettingPicture::OnEnKillfocusEdtW()
{
	// TODO: Add your control notification handler code here
	m_stScreenPara[m_iCurPicNo].iWidth = GetDlgItemInt(IDC_EDT_W);
	if (m_stScreenPara[m_iCurPicNo].iWidth < DEFAULT_PIC_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iWidth = DEFAULT_PIC_SIZE;
	}

	if (m_stScreenPara[m_iCurPicNo].iX + m_stScreenPara[m_iCurPicNo].iWidth > DEFAULT_SCREEN_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iWidth = DEFAULT_SCREEN_SIZE - m_stScreenPara[m_iCurPicNo].iX;
	}

	SetDlgItemInt(IDC_EDT_W, m_stScreenPara[m_iCurPicNo].iWidth);

	DrawMutiPicArea();
}

void CLS_PageSettingPicture::OnEnKillfocusEdtH()
{
	// TODO: Add your control notification handler code here
	m_stScreenPara[m_iCurPicNo].iHeight = GetDlgItemInt(IDC_EDT_H);
	if (m_stScreenPara[m_iCurPicNo].iHeight < DEFAULT_PIC_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iHeight = DEFAULT_PIC_SIZE;
	}

	if (m_stScreenPara[m_iCurPicNo].iY + m_stScreenPara[m_iCurPicNo].iHeight > DEFAULT_SCREEN_SIZE)
	{
		m_stScreenPara[m_iCurPicNo].iHeight = DEFAULT_SCREEN_SIZE - m_stScreenPara[m_iCurPicNo].iY;
	}

	SetDlgItemInt(IDC_EDT_H, m_stScreenPara[m_iCurPicNo].iHeight);

	DrawMutiPicArea();
}

void CLS_PageSettingPicture::OnOK()
{
	// TODO: Add your specialized code here and/or call the base class
	if (GetFocus() == GetDlgItem(IDC_EDT_X))
	{
		OnEnKillfocusEdtX();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_Y))
	{
		OnEnKillfocusEdtY();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_W))
	{
		OnEnKillfocusEdtW();
	}

	if (GetFocus() == GetDlgItem(IDC_EDT_H))
	{
		OnEnKillfocusEdtH();
	}
}

void CLS_PageSettingPicture::OnBnClickedButtonScreenDisplay()
{
	// TODO: Add your control notification handler code here
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);

	int iPos = GetComboData(&m_cboPosNum);
	
	int iDisplay = m_cboScreenDisplay.GetCurSel();
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iVVOChannelNo, iPos, CMD_DEC_CFG_SCREEN_DISPLAY, &iDisplay, sizeof(int));
	if (0 == iRet)
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_SCREEN_DISPLAY] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_SCREEN_DISPLAY] failed......\n"));
	}
}

void CLS_PageSettingPicture::OnCbnSelchangeComboScreenNum()
{
	// TODO: Add your control notification handler code here
	m_iCurPicNo = GetComboData(&m_cboPosNum);
	GetScreenDisplayInfo();
	GetScreenAreaInfo();
}

void CLS_PageSettingPicture::GetScreenDisplayInfo()
{
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);

	int iPos = GetComboData(&m_cboPosNum);

	int iDisplay = -1;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iVVOChannelNo, iPos, CMD_DEC_CFG_SCREEN_DISPLAY, &iDisplay, sizeof(int));
	if (0 == iRet)
	{
		if (iDisplay >= 0)
		{
			m_cboScreenDisplay.SetCurSel(iDisplay);
		}
		else
		{
			m_cboScreenDisplay.SetCurSel(1);	//Ĭʾ
		}
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_DISPLAY] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_DISPLAY] failed......\n"));
	}
}

void CLS_PageSettingPicture::OnBnClickedButtonSignalScreenSet()
{
	// TODO: Add your control notification handler code here
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);

	int iPos = GetComboData(&m_cboPosNum);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iVVOChannelNo, iPos
		, CMD_DEC_CFG_SCREEN_CHANGEAREA, &m_stScreenPara[iPos], sizeof(ScreenPara));
	if (0 == iRet)
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] failed......\n"));
	}
}

void CLS_PageSettingPicture::GetScreenAreaInfo()
{
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);

	int iPos = GetComboData(&m_cboPosNum);

	ScreenPara tScreenPara = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iVVOChannelNo, iPos
		, CMD_DEC_CFG_SCREEN_CHANGEAREA, &tScreenPara, sizeof(ScreenPara));
	if (0 == iRet)
	{
		SetDlgItemInt(IDC_EDT_X, tScreenPara.iX);
		SetDlgItemInt(IDC_EDT_Y, tScreenPara.iY);
		SetDlgItemInt(IDC_EDT_W, tScreenPara.iWidth);
		SetDlgItemInt(IDC_EDT_H, tScreenPara.iHeight);
		DrawMutiPicArea();
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_SCREEN_CHANGEAREA] failed......\n"));
	}
}

void CLS_PageSettingPicture::OnBnClickedButtonSavePiclevelRelation()
{
	// TODO: Add your control notification handler code here
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);
	ChannelPicNum tPicNum = {0};
	tPicNum.iSize = sizeof(ChannelPicNum);
	//ȡͨ
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iVVOChannelNo, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
	if (ERR_SUCCESS != iRet)
	{
		return;
	}

	CString cstrLevel;
	m_edtPicLevel.GetWindowText(cstrLevel);
	string strSourceString = cstrLevel;
	string strLevel[DEC_MAX_WINDOW_TOTAL_NUM];
	SplitStringToArray(strSourceString, ",", strLevel, DEC_MAX_WINDOW_TOTAL_NUM);
	for (int i = 0; i < tPicNum.iPicNum && i < DEC_MAX_WINDOW_TOTAL_NUM; i++)
	{
		m_tPicLevel.iLevelArray[i] = atoi(strLevel[i].c_str());
	}

	m_tPicLevel.iSize = sizeof(DecPicLevelRelation);
	m_tPicLevel.iPicCount = tPicNum.iPicNum;
	iRet = DEC_ClientSetDevConfig(m_lLogonID, iVVOChannelNo, 0, CMD_DEC_CFG_PICLEVEL_RELATION, &m_tPicLevel, sizeof(DecPicLevelRelation));
	if (ERR_SUCCESS == iRet)
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_PICNUM] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientSetDevConfig[CMD_DEC_CFG_PICNUM] failed......\n"));
	}
}

void CLS_PageSettingPicture::UpdatePicLevelRelation()
{
	m_edtPicLevel.SetWindowText("");
	int iVVOChannelNo = GetComboData(&m_cboScreenNo);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iVVOChannelNo, 0, CMD_DEC_CFG_PICLEVEL_RELATION, &m_tPicLevel, sizeof(DecPicLevelRelation));
	if (ERR_SUCCESS == iRet)
	{
		int iPicCount = m_tPicLevel.iPicCount;
		if (iPicCount <= 0) {
			return;
		}

		char cLevel[LEN_1024] = {0};
		char cTmp[LEN_32] = {0};
		int i = 0;
		for (; i < iPicCount; ++i)
		{
			sprintf(cTmp, "%d", m_tPicLevel.iLevelArray[i]);
			strcat(cLevel, cTmp);
			if (i < iPicCount - 1)
			{
				strcat(cLevel, ",");
			}
		}

		m_edtPicLevel.SetWindowText(cLevel);
		OutputDebugString(_T("DEC_ClientGetDevConfig[CMD_DEC_CFG_PICNUM] success......\n"));
	}
	else
	{
		OutputDebugString(_T("DEC_ClientgetDevConfig[CMD_DEC_CFG_PICNUM] failed......\n"));
	}
}
